const axios = require("axios");
const amazonAdsConfig = require("../config/amazon");

const getHeaders = async (accountID, contentType, accept) => {
    const accessToken = await amazonAdsConfig.getValidAccessToken();
    return {
        "Authorization": `Bearer ${accessToken}`,
        "Amazon-Advertising-API-ClientId": amazonAdsConfig.clientId,
        "Amazon-Advertising-API-Scope": accountID,
        "Content-Type": contentType,
        "Accept": accept
    };
};

const productsAdsSP = async (accountID) => {
    const apiUrl = "https://advertising-api.amazon.com/sp/productAds/list";
    const contentType = "application/vnd.spProductAd.v3+json";
    const accept = "application/vnd.spProductAd.v3+json";

    try {
        const headers = await getHeaders(accountID, contentType, accept);
        const response = await axios.post(apiUrl, null, { headers });
        return response.data;
    } catch (error) {
        if (error.response && error.response.status === 401) {
            const newHeaders = await getHeaders(accountID, contentType, accept);
            const retryResponse = await axios.post(apiUrl, null, { headers: newHeaders });
            return retryResponse.data;
        } else {
            throw new Error("Error al obtener los ASINs SP: " + (error.response?.status || error.message));
        }
    }
};

const productsAdsSB = async (accountID) => {
    const apiUrl = "https://advertising-api.amazon.com/sb/v4/ads/list";
    const contentType = "application/vnd.sbadresource.v4+json";
    const accept = "application/vnd.sbadresource.v4+json";

    try {
        const headers = await getHeaders(accountID, contentType, accept);
        const response = await axios.post(apiUrl, null, { headers });
        return response.data;
    } catch (error) {
        if (error.response && error.response.status === 401) {
            const newHeaders = await getHeaders(accountID, contentType, accept);
            const retryResponse = await axios.post(apiUrl, null, { headers: newHeaders });
            return retryResponse.data;
        } else {
            throw new Error("Error al obtener los ASINs SB: " + (error.response?.status || error.message));
        }
    }
};

module.exports = { productsAdsSP, productsAdsSB };
