const axios = require("axios");
const amazonAdsConfig = require("../config/amazon");

const getHeaders = async (accountID, contentType, accept) => {
    const accessToken = await amazonAdsConfig.getValidAccessToken();
    return {
        "Authorization": `Bearer ${accessToken}`,
        "Amazon-Advertising-API-ClientId": amazonAdsConfig.clientId,
        "Amazon-Advertising-API-Scope": accountID,
        "Content-Type": contentType,
        "Accept": accept
    };
};

const adGroupsListSP = async (accountID) => {
    const apiUrl = "https://advertising-api.amazon.com/sp/adGroups/list";
    const contentType = "application/vnd.spadGroup.v3+json";
    const accept = "application/vnd.spadGroup.v3+json";

    try {
        const headers = await getHeaders(accountID, contentType, accept);
        const response = await axios.post(apiUrl, null, { headers });
        return response.data;
    } catch (error) {
        if (error.response && error.response.status === 401) {
            const newHeaders = await getHeaders(accountID, contentType, accept);
            const retryResponse = await axios.post(apiUrl, null, { headers: newHeaders });
            return retryResponse.data;
        } else {
            throw new Error("Error al obtener los adgroups SP: " + (error.response?.status || error.message));
        }
    }
};

const adGroupsListSB = async (accountID) => {
    const apiUrl = "https://advertising-api.amazon.com/sb/v4/adGroups/list";
    const contentType = "application/vnd.sbadgroupresource.v4+json";
    const accept = "application/vnd.sbadgroupresource.v4+json";

    try {
        const headers = await getHeaders(accountID, contentType, accept);
        const response = await axios.post(apiUrl, null, { headers });
        return response.data;
    } catch (error) {
        if (error.response && error.response.status === 401) {
            const newHeaders = await getHeaders(accountID, contentType, accept);
            const retryResponse = await axios.post(apiUrl, null, { headers: newHeaders });
            return retryResponse.data;
        } else {
            throw new Error("Error al obtener los adgroups SB: " + (error.response?.status || error.message));
        }
    }
};

module.exports = { adGroupsListSP, adGroupsListSB };
